﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Globalization;

namespace RevisionAnalyser.Projects.RecoderProject
{
    public partial class MultiDateForm : Form
    {
        private DateTime _min;
        private DateTime _max;
        private int _limitIndex;

        public MultiDateForm(DateTime min, DateTime max, int limitIndex)
        {
            _min = min;
            _max = max;
            _limitIndex = limitIndex;
            InitializeComponent();
        }

        public int GetLimitIndex()
        {
            return uxLimitField.SelectedIndex;
        }

        public SortedDictionary<DateTime, DateTime> GetDates()
        {
            SortedDictionary<DateTime, DateTime> dates = new SortedDictionary<DateTime, DateTime>();
            foreach (ListViewItem item in uxDateView.Items)
            {
                DateTime from;
                DateTime to;
                DateTime.TryParse(item.SubItems[0].Text, CultureInfo.CurrentCulture, DateTimeStyles.AssumeUniversal, out from);
                DateTime.TryParse(item.SubItems[1].Text, CultureInfo.CurrentCulture, DateTimeStyles.AssumeUniversal, out to);
                dates.Add(from, to);
            }
            return dates;
        }

        private void MultiDateForm_Load(object sender, EventArgs e)
        {
            uxFromField.Value = uxFromField.MinDate = uxToField.MinDate = _min;
            uxToField.Value = uxToField.MaxDate = uxFromField.MaxDate = _max;
            uxLimitField.SelectedIndex = _limitIndex;
        }

        private void uxAddButton_Click(object sender, EventArgs e)
        {
            if (uxToField.Value.CompareTo(uxFromField.Value) >= 0)
            {
                bool duplicate = false;
                foreach (KeyValuePair<DateTime, DateTime> date in GetDates())
                {
                    if (uxFromField.Value.CompareTo(date.Value.Date) < 0 && uxToField.Value.CompareTo(date.Key.Date) > 0)
                    {
                        MessageBox.Show("This date range is already covered (partly) by another date.", "Invalid date range", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                        duplicate = true;
                        break;
                    }
                }
                if (!duplicate)
                {
                    uxDateView.Items.Add(new ListViewItem(new string[] { uxFromField.Value.ToShortDateString(), uxToField.Value.ToShortDateString() }));
                    uxSearchButton.Enabled = true;
                }
            }
            else
            {
                MessageBox.Show("Invalid date range.", "Invalid date range", MessageBoxButtons.OK, MessageBoxIcon.Warning);
            }
        }

        private void uxCancelButton_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void uxDateView_SelectedIndexChanged(object sender, EventArgs e)
        {
            uxDeleteButton.Enabled = uxDateView.SelectedItems.Count > 0;
        }

        private void uxDeleteButton_Click(object sender, EventArgs e)
        {
            foreach (ListViewItem item in uxDateView.SelectedItems)
            {
                uxDateView.Items.Remove(item);
            }
            uxSearchButton.Enabled = uxDateView.Items.Count > 0;
        }

        private void uxSearchButton_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.OK;
            Close();
        }
    }
}
